Python CLI Steps Explained {#pyexpl}
==============================================================

---

---

This page details the steps that are performed when a <mark>`QAMgr`</mark> object
  is created and its <mark>`.run()`</mark> method is called.
You should not need to run these steps individually unless you are experiencing errors.<br>

## Setup
```python
from qamgr import *
```
This loads the qamgr package.<br>
*Note: The first time you import qamgr after installing or updating on Windows, you may see some warnings about
  escape sequences. These can be safely ignored.* <br>

---

## Creating the QAMgr Object
You can specify a DICOM RTPLAN file manually by either typing or pasting it in place of <mark>`<FILENAME>`</mark>:
```python
q = QAMgr('<FILENAME>')
```
Alternately, you can choose from a list of files by simply creating the QAMgr object without and argument:
```python
q = QAMgr()
```
In either case, calling the <mark>`QAMgr`</mark> constructor prompts the user for their initials,
  then loads the DICOM file and extracts the needed information.<br>
It also prints some basic information about what it found in the DICOM file;
  you can see this information again at any time by calling <mark>`q.info()`</mark>.<br>

---

## ***PROGRESS MARKER***

---

## Primary Functions
You should (hopefully) only need a few commands for basic analysis while running.<br>
These are <mark>`QAMgr.show_record()`</mark>,
  <mark>`QAMgr.profile()`</mark>, and <mark>`QAMgr.save_profile()`</mark>.<br>
For conveniently scrolling through the entries, there is also a pair of functions
  <mark>`QAMgr.show_next_record()`</mark> and <mark>`QAMgr.show_prev_record()`</mark>.

---

## Plotting and Saving the Overall Pulse-Charge Profile
```python
q.profile()
```
This function shows the distribution of all the delivery records in the log file,
  for `PulseCount` indices 0--1500.
```python
q.save_profile()
```
This function simply saves the profile plot as a `.png` file,
  using the name of the original log file as a base.

---

## Scrolling Through Delivery Records
```python
q.show_record(<RECORD_NUMBER>)		# show a specific delivery record
# and
q.show_next_record()				# scroll through records in order
q.show_prev_record()				# scroll through records in order
```
This is probably the (currently) most-usefule feature; it prints relevant parameters
  for a given delivery record and displays a plot of `Doseplane_pC` vs `Timestamp_us`.<br>
These will probably be your best friends.<br>
For a typical workflow, call <mark>`q.show_next_record()`</mark>, then just keep pressing <mark>`<up>`</mark> and <mark>`<Enter>`</mark>.<br>
***Note: As of v0.9.0, QAMgr will automatically check for and import any new data from the logfile
  if you call <mark>`show_next_record()`</mark> while on the final record.***

---

## Object Summaries {#objsum}

You can print summary information at any time using the <mark>`.info()`</mark> method,
  which is shared by the main object <mark>`flashlogs.QAMgr`</mark>, its child <mark>`flashlogs.DeliveryRecord`</mark>,
  and the delivery record's child <mark>`pandas.DataFrame`</mark> (which contains that record's data table of pulse measurements).<br>
These can be accessed as follows (replace "0" with your choice of file and delivery record):
```python
from flashlogs import *					# import module(s)
la = QAMgr(get_logfile_name(0))	# create QAMgr object and run analysis
q.info()								# print summary for QAMgr
dr = q.get_delivery_record(0)			# retrieve DeliveryRecord object
dr.info()								# print summary for the chosen delivery record
df = dr.pulses							# retrieve pulse data table, which is a PANDAS DataFrame object
df.info()								# print summary for pulse data table
```

---

---

[<-- Prev](Steps.html) || [Contents](index.html#contents) || [Next -->](GettingHelp.html)
