Module Objects {#pyexpl}
==============================================================

---

---

This page details the objects that are created when a <mark>`QAMgr`</mark> object
  is created and its <mark>`.run()`</mark> method is called.
You should not need to access these unless you are experiencing errors.<br>

## Setup
```python
from qamgr import *
```
This loads the qamgr package.<br>
*Note: The first time you import qamgr after installing or updating on Windows, you may see some warnings about
  escape sequences. These can be safely ignored.* <br>

---

## Creating the QAMgr Object
You can specify a DICOM RTPLAN file manually by either typing or pasting it in place of <mark>`<FILENAME>`</mark>:
```python
q = QAMgr('<FILENAME>')
```
Alternately, you can choose from a list of files by simply creating the QAMgr object without and argument:
```python
q = QAMgr()
```
In either case, calling the <mark>`QAMgr`</mark> constructor prompts the user for their initials,
  then loads the DICOM file and extracts the needed information.<br>
It also prints some basic information about what it found in the DICOM file;
  you can see this information again at any time by calling <mark>`q.info()`</mark>.<br>

---

## Object Heirarchy {#objheir}

The main object <mark>`qamgr.QAMgr`</mark> and its successive child objects
  are structured and retrieved as follows (with duplicate references excluded):<br>
```python
QAMgr                             # q = QAMgr()
├── Patient                       #   pat = q.patient
│   ├── RTPlan                    #     rtp = pat.rtplan
│   └── dcinfo                    #     dci = pat.dcinfo
├── OSInfo                        #   osi = q.os_info
│   ├── MountedDrive0             #     md0 = osi.<DRIVE_LETTER_0>
│   ├── MountedDrive1             #     md1 = osi.<DRIVE_LETTER_1>
│   └── (etc...)                  #     # as above
└── QAStatusMonitor               #   qas = q.status_mon
```
_Note: The <mark>`dcinfo`</mark> object is an instance of the class <mark>`pydicom.dataset.FileDataset`</mark>._

---

## Object Summaries {#objsum}

You can print summary information at any time using the <mark>`.info()`</mark> method,
  which is shared by all of the following objects:<br>
<mark>QAMgr, Patient, RTPlan, OSInfo, MountedDrive, and QAStatusMonitor</mark>.<br>
The only immediate missing object is <mark>QAMgr.Patient.dcinfo</mark>,
  since it is from the <mark>pydicom</mark> package.
However, its top-level information can be summarized by calling
  the <mark>print</mark> function on the dataset object's <mark>.top()</mark> method.
For convenience, all of the mentioned information methods are illustrated
  in the example below:<br>
```python
from qamgr import *               # import module(s)
q = QAMgr()                       # create QAMgr object
q.info()                          # print summary for QAMgr
pat = q.patient                   # retrieve Patient object
pat.info()                        # print summary for Patient
rp = pat.rtplan                   # retrieve RTPlan object
rp.info()                         # print summary for RTPLAN
dc = rp.dcinfo                    # retrieve pydicom dataset object
print(dc.top())                   # print summary for pydicom dataset
osi = q.os_info                   # retrieve OSInfo object
osi.info()                        # print summary for OSInfo
L = osi.L                         # retrieve MountedDrive object for drive 'L:' (Windows) or '/mnt/l' (Mac/Linux)
L.info()                          # print summary for drive L
sm = q.status_mon                 # retrieve QAStatusMonitor object
sm.info()                         # print summary for QAStatusMonitor
```

---

## Running the Steps Individually {#individ}

When <mark>QAMgr.run()</mark> is called, it executes a sequence of steps.
These can be called individually if needed as follows:<br>
```python
from qamgr import *
q = QAMgr()
q.create_subdirs()
q.create_spreadsheet()
q.start_2dc()
q.prepare_report()
q.info()
q.status('nodrives')
```
Please see the Python help for the class (via "<mark>`help(q)`</mark>")
  and the individual functions (via "<mark>`help(q.create_subdirs)`</mark>", "<mark>`help(q.create_spreadsheet)`</mark>", etc.)
  for further information.

---

---

[<-- Prev](Steps.html) || [Contents](index.html#contents) || [Next -->](GettingHelp.html)
