Getting Help {#help}
==============================================================

---

---

You can get details about any module, object, function, etc. (within *QAMgr* or otherwise)
  using Python's built-in <mark>`help`</mark> command.<br>
Note that when requesting help for functions, there is a difference between <mark>`help(some_function)`</mark>
  and <mark>`help(some_function())`</mark>: The former shows help for the function *itself,*
  and the latter shows help for whatever the function *returns,* which could be any Python
  object or datatype (including <mark>`None`</mark>, if the function simply performs an action
  without returning a result).<br>
*Friendly reminder: The term "method" simply refers to a function that is part of a class.*<br>

For example:
```python
# initialize
from qamgr import *
q = QAMgr()
# view help
help(qamgr)								# module
help(q)								# class
help(q.profile)							# class method
help(q.profile())						# class method's result (in this case, a matplotlib.pyplot.Figure object)
help(ls)								# function
help(ls())								# function's result (in this case, a list)
```

Finally, if at any point there is a problem that you cannot resolve, please contact me.<br>
Good luck!<br>

---

---

[<-- Prev](ModuleObjects.html) || [Contents](index.html#contents)
