DOCUMENTATION -- QAMgr v0.9.0
==============================================================

---

---

## Introduction

Welcome to *QAManager*!<br>
This is a Python package designed to streamline the process
  of performing Proton Patient QA.<br>
An example screenshot of the graphical interface is shown below.

---

<img title="QAMgr Screenshot" alt="Screenshot of QAMgr Graphical Interface" src="../../qamgr_screenshot.png" style="width:592px"/><br><br>

---

---

## Overview

*QAManager* is a Python software package for improving
  the process for patient-specific quality assurance (PSQA)
  at the [S. Lee Kling Proton Therapy Center](https://siteman.wustl.edu/treatment/siteman-approach/radiation/external-beam-radiation-therapy/proton-beam-therapy/)
  within the [Siteman Cancer Center](https://siteman.wustl.edu/)
  at the [Washington University School of Medicine (WUSM)](https://medicine.washu.edu/).<br>

It is designed to simultaneously improve the following aspects of proton PSQA:

- Safety
- Reliability
- Efficiency

It accomplishes this by automating as much of the PSQA procedure as possible.<br>
This achieves the following:

- Reduced possibility for human error
- Reduced CPA time per patient
- Reduced CPA fatigue

To use this software package:

- First, ensure that [Python](https://www.python.org/) is installed on your machine (v3.10.6 or later).
- You can check your Python version by running "<mark>`python -V`</mark>" at a terminal (e.g., on Windows, either "<mark>`cmd`</mark>" or "<mark>`powershell`</mark>").
- Try the *Quick Reference* instructions in the [README document](../../README.html).
- If you have any trouble, consult the subsequent chapters.

---

## Contents {#contents}

- [Requirements](Requirements.html)
- [Installing And Updating](InstallingAndUpdating.html)
- [Steps](Steps.html)
- [Module Objects](ModuleObjects.html)
- [Getting Help](GettingHelp.html)

---

_~ Dr. Mark J. Duvall, PhD_ <br>
_~ [`duvall at wustl dot edu`](mailto:duvall@wustl.edu)_ <br>
_~ Last updated 2025/07/03_

---

---

[Next -->](Requirements.html)
