Steps {#steps}
==============================================================

---

---

## First, in Windows: {#windows}

### Open a CLI and Navigate to Your Directory
- Open either CMD or PowerShell, using (for example) either `WinKey+S` or `WinKey+R`<br>
    followed by the name of the program (and then `<Enter>` or `<Return>`).<br>
- Navigate to the directory containing the desired log-file.<br>
  - The commands <mark>`dir`</mark> and <mark>`cd`</mark> should be enough for this.<br>
  - The argument "<mark>`..`</mark>" means "the directory above this one" (e.g., "<mark>`cd ..`</mark>" means "go up one folder").<br>
- Run the command <mark>`python`</mark> to start the Python interpreter.<br>
- If needed, use Windows Explorer to find the log-file you want to analyze,<br>
      and (optionally) copy the filename to the clipboard.<br>

*Note:* You can quit Python at any time using the command "`quit()`".
If you've started Python in the wrong directory, the easiest thing to do is probably
  to just "`quit()`" Python, "`cd`" into the correct folder, then run "`python`" again.

---

## Then, in Python: {#python}

### For the Graphical Interface: {#pythongui}

Run the following at the Python prompt; you should be able to simply follow the GUI from there if it is working properly:<br>
```python
from qamgr import *
q = GuiQAMgr()
```

---

### Or, For the Text Interface: {#pythoncli}

Run the following at the Python prompt:<br>
```python
from qamgr import *
q = QAMgr()
```
You should be prompted to enter your initials and choose a DICOM RP file.
Then simply run the following command:<br>
```python
q.run()
```
This will automatically complete the process and will prompt you for action when necessary.
If you encounter trouble, you may need access to the individual objects;
  they are described on the next page.

---

---

[<-- Prev](InstallingAndUpdating.html) || [Contents](index.html#contents) || [Next -->](ModuleObjects.html)
